/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1267;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2902;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8567;

public abstract class AbstractWhirlwind
extends class_1308 {
    public static final class_2940<Integer> DATA_COLOR_ID = class_2945.method_12791(AbstractWhirlwind.class, (class_2941)class_2943.field_13327);
    private int lifeLeft;
    private int dropsTimer;
    private int stuckTick;
    private float movementAngle;
    private float movementCurve;
    private boolean isEvil = false;

    public AbstractWhirlwind(class_1299<? extends AbstractWhirlwind> type, class_1937 level) {
        super(type, level);
        if (level.method_8608()) {
            this.movementAngle = this.method_59922().method_43057() * 360.0f;
            this.movementCurve = (this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.1f;
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(2, (class_1352)new MoveGoal(this));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, false));
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23719, 0.025).method_26868(class_5134.field_23717, 16.0);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_COLOR_ID, (Object)this.getDefaultColor());
    }

    public static boolean checkWhirlwindSpawnRules(class_1299<? extends AbstractWhirlwind> whirlwind, class_1936 level, class_3730 reason, class_2338 pos, class_5819 random) {
        return class_1308.method_20636(whirlwind, (class_1936)level, (class_3730)reason, (class_2338)pos, (class_5819)random) && level.method_22335(pos, 0) > 12 && level.method_8407() != class_1267.field_5801;
    }

    public void method_5773() {
        super.method_5773();
        --this.lifeLeft;
        if (!this.method_37908().method_8608() && (this.lifeLeft <= 0 || this.aetherFabric$isInFluidType())) {
            this.method_31472();
        }
    }

    public void method_6007() {
        if (!this.method_37908().method_8608()) {
            if (this.field_5992 && !this.field_36331) {
                this.stuckTick += 4;
            } else if (this.stuckTick > 0) {
                --this.stuckTick;
            }
            if (this.method_5968() != null) {
                ++this.dropsTimer;
            }
            if (this.dropsTimer >= 128) {
                this.spawnDrops();
                this.dropsTimer = 0;
            }
        } else {
            this.spawnParticles();
        }
        super.method_6007();
        List<class_1297> entityList = this.method_37908().method_8335((class_1297)this, this.method_5829().method_1012(2.5, 2.5, 2.5)).stream().filter(entity -> !entity.method_5864().method_20210(AetherTags.Entities.WHIRLWIND_UNAFFECTED)).toList();
        for (class_1297 entity2 : entityList) {
            double d1;
            double x = (float)entity2.method_23317();
            double y = (double)((float)entity2.method_23318()) - entity2.method_52538((class_1297)this).method_10214() * (double)0.6f;
            double z = (float)entity2.method_23321();
            double distance = this.method_5739(entity2);
            if (distance <= 1.5 + (d1 = y - this.method_23318())) {
                entity2.method_18800(entity2.method_18798().method_10216(), 0.15, entity2.method_18798().method_10215());
                entity2.method_38785();
                if (d1 > 1.5) {
                    entity2.method_18800(entity2.method_18798().method_10216(), -0.45 + d1 * 0.35, entity2.method_18798().method_10215());
                    distance += d1 * 1.5;
                } else {
                    entity2.method_18800(entity2.method_18798().method_10216(), 0.125, entity2.method_18798().method_10215());
                }
                double d2 = Math.atan2(this.method_23317() - x, this.method_23321() - z) / 0.0175;
                entity2.method_18800(-Math.cos(0.0175 * (d2 += 160.0)) * (distance + 0.25) * 0.1, entity2.method_18798().field_1351, Math.sin(0.0175 * d2) * (distance + 0.25) * 0.1);
                if (entity2 instanceof AbstractWhirlwind) {
                    entity2.method_31472();
                }
            } else {
                double d3 = Math.atan2(this.method_23317() - x, this.method_23321() - z) / 0.0175;
                entity2.method_18799(entity2.method_18798().method_1031(Math.sin(0.0175 * d3) * 0.01, entity2.method_18798().field_1351, Math.cos(0.0175 * d3) * 0.01));
            }
            if (this.method_37908().method_22347(this.method_24515())) continue;
            this.lifeLeft -= 50;
        }
        if (this.stuckTick > 40) {
            this.lifeLeft = 0;
        }
    }

    protected void spawnDrops() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.method_59922().method_43048(4) == 0) {
                class_8567 parameters = new class_8567.class_8568(serverLevel).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1226, (Object)this).method_51875(class_173.field_20762);
                class_52 lootTable = serverLevel.method_8503().method_58576().method_58295(this.getLootLocation());
                ObjectArrayList list = lootTable.method_51878(parameters);
                for (class_1799 itemstack : list) {
                    serverLevel.method_8396(null, this.method_24515(), AetherSoundEvents.ENTITY_WHIRLWIND_DROP.get(), class_3419.field_15251, 0.5f, 1.0f);
                    this.method_5699(itemstack, 1.0f);
                }
            }
        }
    }

    public boolean method_5643(class_1282 source, float damage) {
        return false;
    }

    public void method_5768() {
        this.method_5650(class_1297.class_5529.field_26998);
        this.method_32876((class_6880)class_5712.field_37676);
    }

    public abstract void spawnParticles();

    public abstract class_5321<class_52> getLootLocation();

    public int getColorData() {
        return (Integer)this.method_5841().method_12789(DATA_COLOR_ID);
    }

    public void setColorData(int color) {
        this.method_5841().method_12778(DATA_COLOR_ID, (Object)color);
    }

    public int getLifeLeft() {
        return this.lifeLeft;
    }

    public void setLifeLeft(int lifeLeft) {
        this.lifeLeft = lifeLeft;
    }

    public boolean isEvil() {
        return this.isEvil;
    }

    public void setEvil(boolean evil) {
        this.isEvil = evil;
    }

    public abstract int getDefaultColor();

    public boolean method_6101() {
        return this.field_5976;
    }

    public int method_5945() {
        return 1;
    }

    protected boolean method_23734() {
        return true;
    }

    protected boolean method_5860(class_1297 vehicle) {
        return false;
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10548("Movement Angle", this.movementAngle);
        tag.method_10548("Movement Curve", this.movementCurve);
        tag.method_10569("Life Left", this.lifeLeft);
        tag.method_10569("Color", this.getColorData());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("Movement Angle")) {
            this.movementAngle = tag.method_10583("Movement Angle");
        }
        if (tag.method_10545("Movement Curve")) {
            this.movementCurve = tag.method_10583("Movement Curve");
        }
        if (tag.method_10545("Life Left")) {
            this.lifeLeft = tag.method_10550("Life Left");
        }
        if (tag.method_10545("Color")) {
            this.setColorData(tag.method_10550("Color"));
        }
    }

    protected static class MoveGoal
    extends class_1352 {
        private final AbstractWhirlwind whirlwind;
        protected float movementAngle;
        protected float movementCurve;

        public MoveGoal(AbstractWhirlwind entity) {
            this.whirlwind = entity;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return true;
        }

        public void method_6268() {
            if (this.movementAngle == 0.0f) {
                this.movementAngle = this.whirlwind.movementAngle;
                this.movementCurve = this.whirlwind.movementCurve;
            }
            if (!this.whirlwind.isEvil || this.whirlwind.method_5968() == null) {
                class_2338 offset = class_2338.method_49638((class_2374)this.whirlwind.method_19538().method_1019(this.whirlwind.method_18798()));
                this.movementAngle = this.whirlwind.method_37908().method_8624(class_2902.class_2903.field_13202, offset.method_10263(), offset.method_10260()) < offset.method_10264() - this.whirlwind.method_5850() ? (this.movementAngle += 180.0f) : (this.movementAngle += this.movementCurve);
                double modifier = 1.0;
                class_1324 speed = this.whirlwind.method_5996(class_5134.field_23719);
                if (speed != null) {
                    modifier = speed.method_6194();
                }
                this.whirlwind.method_18800(Math.cos(this.movementAngle * ((float)Math.PI / 180)) * modifier, this.whirlwind.method_18798().field_1351, Math.sin(this.movementAngle * ((float)Math.PI / 180)) * modifier);
            } else {
                this.whirlwind.method_18799(class_243.field_1353);
            }
        }
    }
}

